unit RegInsp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  menus, inspect;

type
  TInspector = class(TComponent)
  private
    { Private declarations }
  protected
    f_Inspector : tf_inspector;
    hkHotKey : TShortCut;
    fAutoStart : Boolean;
    eBeforeShow : tShowEvent;
    sDllPath : ShortString;
    iIconSize : integer;
    { Protected declarations }
  public
    constructor create(AOwner: TComponent); override;
    destructor destroy;  override;
    Procedure Show;
    Procedure Loaded;  Override;
    { Public declarations }
  published
    Property BeforeShow : tShowEvent read ebeforeShow write ebeforeShow;
    property HotKey : tShortCut read hkHotKey write hkHotKey default 49187;
    Property AutoStart : Boolean read fAutoStart write fAutoStart default True;
    Property DllPath : ShortString read sDllPath write sDllPath;
    Property IconSize : Integer read iIconSize write iIconSize default 24;

  end;

procedure Register;

implementation

uses DSEd, SListEd;

Const Created : Boolean = False;

Constructor tInspector.Create;
Begin
  inherited create(aOwner);
//  sDllPath := 'n:\test\paslib\inspect';
  sDllPath := 'c:\inspect';
  hkHotKey := TextToShortCut('Ctrl+Alt+End');
  iIconSize := 24;
  fAutoStart := True;
End;

Procedure tInspector.Loaded;
Begin
  inherited Loaded;
  if not ((csDesigning in ComponentState) or Created) then Begin
    f_Inspector := tf_Inspector.create(Self);
    f_Inspector.BeforeShow := eBeforeShow;
    f_Inspector.HotKey := hkHotKey;
    if fAutoStart then
      f_Inspector.AutoStart;
    Created := True;
  end;
End;

Destructor tInspector.destroy;
begin
  inherited;
end;

Procedure tInspector.Show;
var b  :boolean;
Begin
  b := true;
  if assigned(f_inspector.beforeshow) then
    f_inspector.BeforeShow(self, b);
  if b then f_Inspector.Show;
End;

procedure Register;
begin
  RegisterComponents('Additional', [TInspector]);
end;

end.
